#include <sioux.h>
#include <gusi.h>
#include <TFileSpec.h>
#include <ICCAPI.h>
#include <ICAPI.h>
#include <Files.h>
#include <Folders.h>
#include <TextUtils.h>


#include "MacFiles.h"
#include "HTString.h"
#include "MacInit.h"
#include "SignatureToApp.h"

extern BOOLEAN internet_config;

int MacDownloadFile(char *from, char* to)
{
	OSErr theErr;
	FSSpec fromFS;
	FSSpec interFS;
	FSSpec toFS;
	FSSpec finalFS;
	
	
	char fromFN[256] = " ";
	char toFN[256]  = " :";
	
	
	strcat(fromFN,from);
	strcat(toFN,to);

	fromFN[0] = strlen(from);
	  toFN[0] = strlen(to)+1;

	theErr = FSMakeFSSpec(0,0,(unsigned char *)fromFN,&fromFS);
	theErr = FSMakeFSSpec(fromFS.vRefNum,fromFS.parID,(unsigned char *)toFN,&interFS);
	theErr = FSMakeFSSpec(0,0,"\p:",&toFS);
	
	theErr = FSpRename(&fromFS,(unsigned char *)toFN);

	theErr = FSpCatMove(&interFS,&toFS);
	theErr = FSMakeFSSpec(0,0,(unsigned char *)toFN,&finalFS);
	
	if (internet_config)
	{
		theErr = MacICSetFileType(&finalFS);
		theErr = MacICPostProcess(&finalFS);
	}
	
	return (theErr = noErr);
}

int MacFSRename(char *from, char* to)
{
	OSErr theErr;
	FSSpec fromFS;
	FSSpec interFS;
	FSSpec toFS;
	FSSpec finalFS;
	
	
	char fromFN[256] = " ";
	char toFN[256]  = " :";
	
	
	strcat(fromFN,from);
	strcat(toFN,to);

	fromFN[0] = strlen(from);
	  toFN[0] = strlen(to)+1;
	
	theErr = FSMakeFSSpec(0,0,(unsigned char *)fromFN,&fromFS);
	theErr = FSMakeFSSpec(fromFS.vRefNum,fromFS.parID,(unsigned char *)toFN,&interFS);
	theErr = FSMakeFSSpec(0,0,"\p:",&toFS);
	
	theErr = FSpFileCopy(&fromFS,&toFS,toFN,nil,0,true);
	
	theErr = FSMakeFSSpec(0,0,(unsigned char *)toFN,&finalFS);
	theErr = MacICSetFileType(&finalFS);
	
	return (theErr = noErr);
}

int MacLaunchCommand(char *sig, char* filename)
{
	OSErr theErr;
	FSSpec file;
	FSSpec interFS;
	FSSpec toFS;
	FSSpec finalFS;
	OSType sign;
	
	char filenameP[256]  = " ";
	strcat(filenameP,filename);

	filenameP[0] = strlen(filename);
	
	sprintf((char*)&sign,"%c%c%c%c",sig[0],sig[1],sig[2],sig[3]);
	//printf(" fdType			= %c%c%c%c\n", 	pb.fileParam.ioFlFndrInfo.fdType);
	theErr = FSMakeFSSpec(0,0,(unsigned char *)filenameP,&file);
	theErr = MacICSetFileType(&file);
	theErr = SignatureToApp(sign,&file, NULL,NULL,NULL,
									Sig2App_LaunchApplication,launchContinue);
									
	return (theErr = noErr);
}


OSErr MacICSetFileType(FSSpec *toFS)
{
	OSErr theErr;
	ICMapEntry entry;
	FInfo fileinfo;
	
	
	if (ICpresent)
	{
		theErr = ICBegin(MacICinst,icReadOnlyPerm);
		theErr = ICMapFilename(MacICinst, &toFS->name, &entry);
		theErr = ICEnd(MacICinst);
	}	
	theErr = FSpGetFInfo(toFS,&fileinfo);
	fileinfo.fdType = entry.file_type;
	fileinfo.fdCreator = entry.file_creator;
	theErr = FSpSetFInfo(toFS,&fileinfo);
		
	return theErr;
}

OSErr MacICPostProcess(FSSpec *toFS)
{
	OSErr theErr;
	ICMapEntry entry;
		
	if (ICpresent)
	{
		ICBegin(MacICinst,icReadOnlyPerm);
		theErr = ICMapFilename(MacICinst, &toFS->name, &entry);
		ICEnd(MacICinst);
	}	
	
	if ((theErr == noErr) && (entry.flags & /*(1L <<*/ ICmap_post_mask)) 
		theErr = SignatureToApp(entry.post_creator,toFS, NULL,NULL,NULL,
										Sig2App_LaunchApplication,launchContinue);
									
	return theErr;
}

char * MacGetHomeDir()
{
	OSErr anErr;
	FSSpec tempFolder;

	char *tempFiles = (char*) malloc(255);
	strcpy(tempFiles,"/");
	
	anErr =  Path2FSSpec(":",&tempFolder);
	strcat(tempFiles, HTMac_wwwName(FSp2FullPath(&tempFolder)));

	return tempFiles;
}

char * MacGetTempSpace()
{
	OSErr anErr;

	FSSpec tempFolder;

	char *tempFiles = (char*) malloc(255);
	strcpy(tempFiles,"");
	
	anErr = Special2FSSpec(kTemporaryFolderType, 0, 0,&tempFolder);
	strcat(tempFiles, FSp2FullPath(&tempFolder));

	return tempFiles;
}

char * urltomac(char *url)
{

	char *cp_newurl = (char*) malloc(strlen(url));
	char *cp_url;

	strcpy(cp_newurl, url);

	for(cp_url = cp_newurl; *cp_url != '\0'; cp_url++)	{
		if(*cp_url == '/')	{
			*cp_url = ':';
		}
	}

	return cp_newurl; 
}

/* PUBLIC                                                       HTMac_wwwName()
**              CONVERTS Mac Name into WWW Name
** ON ENTRY:
**      macname         MacOS file specification (NO NODE)
**
** ON EXIT:
**	returns 	www file specification
**
*/
char * HTMac_wwwName (char *macname)
{
	char *wwwname;
	int tmp;
			 
	wwwname = (char*) malloc(strlen(macname));
	strcpy(wwwname, macname);

	for(tmp = 0; wwwname[tmp] != '\0'; tmp++)	
		if(wwwname[tmp] == ':')	
			wwwname[tmp] = '/';
/*
	if((strlen(wwwname)>2)&&(wwwname[1]==':')) wwwname[1]='|';
	printf("\n\nwww: %s\n\ndos: %s\n\n",wwwname,dosname);
	sleep(5);
*/
	return(wwwname);
}



/* PUBLIC                                                       HTMac_name()
**              CONVERTS WWW name into a Mac name
** ON ENTRY:
**	fn		WWW file name
**
** ON EXIT:
**      returns         Mac file specification
**
** Bug:	Returns pointer to static -- non-reentrant
*/
char * HTMac_name(char *macname)	
{
//	static char cp_url[1024];
	int joe;

	char *cp_url;
	
	if (macname[0] == '/')
			 macname++;
			 
	cp_url = (char*) malloc(strlen(macname));
	strcpy(cp_url, macname);
	
//	memset(cp_url, 0, 1023);
/*	strset(cp_url,0); */
//	sprintf(cp_url, "%s",macname);

	for(joe = 0; cp_url[joe] != '\0'; joe++)	{
		if(cp_url[joe] == '/')	{
			cp_url[joe] = ':';
		}
	}
	return cp_url;
//	if(strlen(cp_url) < 4) cp_url[] = ':';
/*	if(strlen(cp_url) == 3) cp_url[3] = '\\';

	if(strlen(cp_url) == 4) cp_url[4] = '.';

	if((strlen(cp_url) > 2) && (cp_url[1] == '|'))
		cp_url[1] = ':';
*/
/*	if((cp_url[1] == '\\') || (cp_url[0]  != '\\'))
	{
*
		printf("\n\n%s = i%\n\n",cp_url,strlen(cp_url));
		sleep(5);
**
		return(cp_url);
	} else {
*
		printf("\n\n%s = %i\n\n",cp_url+1,strlen(cp_url));
		sleep(5);
**
		return(cp_url+1);
	}*/
}


void urltomacfs(char *cp_url)	
{
/*
	Purpose:	convert a url to a dos path
	Arguments:	cp_url	the url to convert
	Return Value:	void
	Remarks/Portability/Dependencies/Restrictions:
		Will overwrite the cp_url memory in order to provide the new
			path.
		Does not actually take a complete url, only the part passed
			in by a routine in htfile.c
	Revision History:
		01-18-94	created for DOSLYNX
		02-15-97	massaged into Lynx for Win32
*/

	/*
	  Allocate space for the new name.
	  Remember the address of the original url
	*/

	char *cp_newurl = (char*) malloc(strlen(cp_url) + 1);
	char *cp_oldurl = cp_url;

/*	if(strlen(cp_url) == 4)
		StrAllocCat(cp_url,":");
*/
/*	if(cp_url[strlen(cp_url)-1] == '\\')
		cp_url[strlen(cp_url)-1] = 0;
*/
	if(cp_url[strlen(cp_url)-1] == '/')
		cp_url[strlen(cp_url)-1] = 0;

	/*
	  Skip the always leading '/'
	*/

	if ((cp_url[0] == '/') && (cp_url[1] == ':'))
		 cp_url++;

	/*
	  Next comes the drive letter.
	*/

/*	*cp_newurl = *cp_url;
	cp_url++;
*/
	/*
	  If the last character was a drive letter, this will be
	  a '|', if not, the rest must be a file name.
	*/
/*
	if(*cp_url == '|')	{
		*(cp_newurl + 1) = ':';
	}
	else	{
*/
		/*
		  Just copy over another character.
		*/

	//	*(cp_newurl + 1) = *cp_url;
	//}

	/*
	  Move past the '|'
	*/

//	cp_url++;

	/*
	  Copy the rest of the string over.
	*/

	strcpy(cp_newurl/* + 2*/, cp_url);

	/*
	  Loop through the string, converting all '/' to ':'
	*/

	for(cp_url = cp_newurl; *cp_url != '\0'; cp_url++)	{
		if(*cp_url == '/')	{
			*cp_url = ':';
		}
	}

	/*
	  Done, copy back over the new url, and release our memory.
	*/

	strcpy(cp_oldurl, cp_newurl);
	free(cp_newurl);

}

//~~~~~~~~~~~~~~local funcs


inline void pstrcat(StringPtr dst, StringPtr src)
{

	/* copy string in */
	BlockMoveData(src + 1, dst + *dst + 1, *src);
	/* adjust length byte */
	*dst += *src;

} // pstrcat

// convert a DirID and vRefNum into a full path appending it to the given Handle
// I forget where I got this code, probable a Developer CD - thanks to whoever!
static OSErr get_full_path(long dir_id, short v_ref, Handle path_cstr_h)
{

	DirInfo	block;
	Str255	director_name_pstr;
	long	path_original_length = GetHandleSize(path_cstr_h);
	long	path_current_length = path_original_length;
	OSErr	err = noErr;

	block.ioDrParID = dir_id;
	block.ioNamePtr = director_name_pstr;
	do {
		int		length;
	
		block.ioVRefNum = v_ref;
		block.ioFDirIndex = -1;
		block.ioDrDirID = block.ioDrParID;
		if ( (err = PBGetCatInfoSync((CInfoPBPtr)&block)) != noErr )
			break;
		pstrcat(director_name_pstr, (StringPtr)"\001:");
		length = *director_name_pstr;
		
		SetHandleSize(path_cstr_h, path_current_length + length);
		if ( (err = MemError()) != noErr )
			break;
		BlockMoveData(*path_cstr_h + path_original_length, *path_cstr_h + path_original_length + length, path_current_length - path_original_length);
		BlockMoveData(director_name_pstr + 1, *path_cstr_h + path_original_length, length);
		path_current_length += length;
	} while (block.ioDrDirID != 2);
	
	return err;

} // get_full_path



char * getFullPath(const FSSpec* file_spec_ptr)
{
	// begin to build up the URL string
	char * filename;
	long i;
	long end = 0;
	// start with the "/" specifier, the "file://" will be added later
	Handle			path_cstr_h = NULL;
	OSErr error = PtrToHand("/", &path_cstr_h, sizeof("/") - 1);	// -1 because we don't want the NULL

	// append the full path to the folder
	error = get_full_path(file_spec_ptr->parID, file_spec_ptr->vRefNum, path_cstr_h);
	if ( error == noErr )
	{
		// append the file name to the URL string
		error = PtrAndHand(&file_spec_ptr->name[1], path_cstr_h, file_spec_ptr->name[0]);
		if ( error == noErr )
		{
			end = GetHandleSize(path_cstr_h);
			(*path_cstr_h)[end]=0;
		}
	}

	// clean up and we're done
	if (error == noErr)
	{
		/*filename = (char*)malloc(end);
		for (i=1;i<=end;i++)
			filename[i-1]=path_cstr_h[i];
		DisposeHandle(path_cstr_h);
		*/return *path_cstr_h;
	}
	else
		return NULL;

} // ICLaunchFile






